 ; Ŀ
 ;   Hang - kill beaver and permit stamps.                                 
 ;   Copyright 1994, 2001, 2003, 2004, 2006, 2008 by Rocket Software Ltd.  
 ;                                                                         
 ; 

 ; Ŀ
 ;   Gobo - make current the space occupied by an entity.                  
 ;   Arguments: Enam, the entity name.                                     
 ;   Calls nothing, Returns nothing.                                       
 ; 
 (DEFUN GOBO (enam / ctab)
  (setq ctab (cdr (assoc 410 (entget enam))))
 ; Ŀ
 ;   Set the space containing the entity to be current.                    
 ; 
  (setvar "ctab" ctab)
 ; Ŀ
 ;   If it is not in the Model tab, make sure we are in paper space.       
 ; 
  (if (/= (getvar "ctab") "Model") (command ".pspace"))
 (princ))
 ; Ŀ
 ;   Gobo end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Idak - see if a block contains the single-character text   
 ;   subentities required to make the word Engineer.  Takes the first      
 ;   subentity list from the block definition as its sole argument,        
 ;   returns T if all characters are present, else ().                     
 ; 
 (DEFUN IDAK (subnam / len entt txt strlst subnam n1 n2 n3 n4 n5 n6 n7 n8)
  (setq len 1)
  (while (and subnam (= len 1))
         (setq entt (entget subnam))
         (if (and (= (cdr (assoc 0 entt)) "TEXT")
                  (setq len (strlen (setq txt (cdr (assoc 1 entt)))))
                  (member txt (list "E" "N" "G" "I" "R")))
             (setq strlst (append strlst (list txt))))
         (setq subnam (entnext subnam)))
  (setq look "--------")
  (while (and (setq txt (car strlst))
              (/= look "ENGINEER"))
         (setq strlst (cdr strlst))
         (cond ((and (null n1) (= txt "E"))
                (setq n1 t)
                (setq look (strcat txt (substr look 2))))
               ((and (null n2) (= txt "N"))
                (setq n2 t)
                (setq look (strcat (substr look 1 1) txt (substr look 3))))
               ((and (null n3) (= txt "G"))
                (setq n3 t)
                (setq look (strcat (substr look 1 2) txt (substr look 4))))
               ((and (null n4) (= txt "I"))
                (setq n4 t)
                (setq look (strcat (substr look 1 3) txt (substr look 5))))
               ((and (null n5) (= txt "N"))
                (setq n5 t)
                (setq look (strcat (substr look 1 4) txt (substr look 6))))
               ((and (null n6) (= txt "E"))
                (setq n6 t)
                (setq look (strcat (substr look 1 5) txt (substr look 7))))
               ((and (null n7) (= txt "E"))
                (setq n7 t)
                (setq look (strcat (substr look 1 6) txt (substr look 8))))
               ((and (null n8) (= txt "R"))
                (setq n8 t)
                (setq look (strcat (substr look 1 7) txt)))))
  (if (and n1 n2 n3 n4 n5 n6 n7 n8) t ()))
 ; Ŀ
 ;   Subroutine Idak end.                                                  
 ; 

 ; Ŀ
 ;   Hanx.                                                                 
 ; 
 (DEFUN HANX (blist / nokill reww bldat blnam sube)
  (setq nokill (list "TB" "MAINTB" "GELTITLE" "WIRELINE" "PERMALTA"
                     "PQPERMIT" "REVTB" "INTRAGAZ" "PLOTDATE" "REVTRI"
                     "FIELDTB" "1WIRETAG" "TITLEBLK" "N-ARROW"
                     "P-END" "JBSHIELD" "3WSHIELD" "2WSHIELD" "2WCTSHLD"
                     "T2A-3"))
  (setq reww T)
  (while (setq bldat (tblnext "block" reww))
         (setq reww ())
         (setq blnam (cdr (assoc 2 bldat)))
         (setq sube (cdr (assoc -2 bldat)))
         (if (and (not (member (strcase blnam) nokill))
                  (or (idak sube)
                      (tang '("PERMIT TO PRACTICE") sube)))
             (setq blist (cons blnam blist))))
 blist)
 ; Ŀ
 ;   Hanx end.                                                             
 ; 

 ; Ŀ
 ;   Idacc - make a list of block names.                                   
 ;   Takes no arguments, returns a list.  Independent and ruthless.        
 ; 
 (DEFUN IDACC ()
  (list "beaver"
        "BC_PEng_mono"
        "beck"      "bcbeck"    "skbeck"
        "bozek"     "skbozek"
        "budd"
        "checkryn"
        "dancy"
        "delind"
        "fast"
        "freemant"
        "gemsask"
        "gondek"
        "hayden"
        "henderson" "skhender"
        "huitema"   "bchuitem"  "quhuitem"  "skhuitem"
        "ibrahim"
        "isbister"  "skisbstr"
        "jajarmi"   "bcjajarmi" "skjajarmi"
        "johnson"   "bcjohnsn"  "skjohnsn"
        "jones"     "bcjones"   "skjones"
        "jorgense"  "skjorgen"
        "joy"       "bcjoy"     "skjoy"
        "kurrant"
        "majer"
        "macdonel"
        "mcdougal"
        "mclenhan"
        "newman"    "bcnewman"  "qunewman"  "sknewman"
        "nguyen"
        "permit"    "peng"
        "permab"    "permalta"  "permabkp"  "00permit"
        "permsask"  "permsask1"
        "pavan"     "skpavan"
        "pickel"    "skpickel"
        "rawlyk"
        "redko"
        "sawatzky"  "bcsawat"   "sksawatzky"
        "slupsky"
        "smerek"
        "snowdon"   "bcsnowdn"
        "ta"
        "tardif"
        "warners"
        "zotzman"
        "AB - Arnold"    "AB - Cramer"   "AB - Freeman"
        "AB - Jajarmi"   "AB - Joy"      "AB - Kondics"
        "AB - Newman"    "AB - Permit"   "AB - Quon"
        "AB - Robillard" "AB - Velichko" "AB - Warners"
        "AB - Watts"     "AB - Yee"      "BC - Cramer"
        "BC - Freeman"   "BC - Kondics"
        "Peng _Permit_Stamp_CNRL TB"
        "Peng _Permit_Stamp_Encana TB"
        "Peng _Permit_Stamp_Huskey TB"
        "Peng _Permit_Stamp_Tridyne TB"
        "SK - Cramer"    "SK - Freeman"  "SK - Kondics"
        "SK - Newman"    "SK - Permit"   "SK - Velichko"))
 ; Ŀ
 ;   Idacc end.                                                            
 ; 

 ; Ŀ
 ;   Isxnam: see if a given block is an xref.                              
 ;   Argument: Blnam, the block name.                                      
 ;   Returns T: it was an xref, or nil: it wasn't, or no such block is     
 ;   is defined in the drawing.                                            
 ; 
 (DEFUN ISXNAM (blnam / isxrf xp dat)
  (if (setq dat (tblsearch "block" blnam))
      (progn
           (setq xp (cdr (assoc 70 dat)))
           (setq isxrf (logand xp 4))))
 (if (= isxrf 4) T ()))
 ; Ŀ
 ;   Isxnam end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Ridd - get rid of a block or xref, purge it if required.   
 ;   Takes one argument, a block name.  Returns nothing.                   
 ;   Xrefs vs. Insertions:                                                 
 ;   If a block is inserted then can't xref it in - must detach.           
 ;   Similarly, if a block is xrefed then can't insert - must erase        
 ;   and purge.                                                            
 ; 
 (DEFUN RIDD (blnam / ss)
  (if (tblsearch "block" blnam)
      (progn
 ; Ŀ
 ;   If the block is an xref then detach it.                               
 ; 
           (if (isxnam blnam)
               (command "-xref" "d" blnam))
 ; Ŀ
 ;   If there are still any copies then either they were normal blocks     
 ;   or the xref was nested and can't be detached, so erase them.          
 ; 
           (if (and (tblsearch "block" blnam)
                    (setq ss (ssget "X" (list (cons 2 blnam)))))
               (sprase ss))
 ; Ŀ
 ;   If the block is still in the block tables and it isn't an xref then   
 ;   purge it.                                                             
 ; 
           (if (and (tblsearch "block" blnam)
                    (not (isxnam blnam)))
               (command "-purge" "block" blnam "n"))))
 (princ))
 ; Ŀ
 ;   Ridd end.                                                             
 ; 

 ; Ŀ
 ;   Sprase - erase things which may be in different spaces.               
 ;   Arguments: Ss, a slelection set of stuff to erase.                    
 ;   Calls Gobo, Returns nothing.                                          
 ; 
 (DEFUN SPRASE (ss / num enam)
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (gobo enam)
         (command ".erase" enam ""))
 (princ))
 ; Ŀ
 ;   Sprase end.                                                           
 ; 

 ; Ŀ
 ;   Sridd - detach or erase and purge blocks named in a list.             
 ;   Arguments: Blist, a list of block names.                              
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN SRIDD (blist / num blnam)
  (setq num 0)
  (while (and blist (setq blnam (nth num blist)))
         (setq num (1+ num))
         (ridd blnam))
 (princ))
 ; Ŀ
 ;   Sridd end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Tang - see if a block contains any text string in a list.  
 ;   Arguments: Strls, a list of text strings.                             
 ;              Subnam, the 1st subentity list from the block definition.  
 ;   Returns T if a string was found, else ().                             
 ; 
 (DEFUN TANG (strls subnam / entt txt subnam found)
  (while (and subnam (null found))
         (setq entt (entget subnam))
         (if (and (= (cdr (assoc 0 entt)) "TEXT")
                  (setq txt (cdr (assoc 1 entt)))
                  (member txt strls))
             (setq found t))
         (setq subnam (entnext subnam)))
 found)
 ; Ŀ
 ;   Subroutine Tang end.                                                  
 ; 

 ; Ŀ
 ;   Hang.                                                                 
 ; 
 (DEFUN C:HANG (/ blist)
  (setvar "cmdecho" 0)
  (setq blist (idacc))
  (setq blist (hanx blist))
  (sridd blist)
 (princ))